const db = require('../config/database');

exports.saveToken = (token) => {
    return new Promise((resolve, reject) => {
        db.query('INSERT INTO access_tokens (token, created_at) VALUES (?, NOW())', [token], (err, results) => {
            if (err) reject(err);
            resolve(results);
        });
    });
};

exports.validateToken = (token) => {
    return new Promise((resolve, reject) => {
        db.query('SELECT * FROM access_tokens WHERE token = ?', [token], (err, results) => {
            if (err) reject(err);
            resolve(results.length > 0);
        });
    });
};
