const db = require('../config/database'); // Ensure you have a proper DB connection

// Get states by country name
exports.getStates = (countryName) => {
    return new Promise((resolve, reject) => {
        const query = `
            SELECT states.* 
            FROM states 
            JOIN country ON country.id = states.country_id 
            WHERE country.country_name = ?`;
        
        db.query(query, [countryName], (err, results) => {
            if (err) reject(err);
            resolve(results);
        });
    });
};

// Get cities by state name
exports.getCitiesByState = (stateName) => {
    return new Promise((resolve, reject) => {
        const query = `
            SELECT cities.* 
            FROM cities 
            JOIN states ON states.id = cities.state_id 
            WHERE states.state_name = ?`;
        
        db.query(query, [stateName], (err, results) => {
            if (err) reject(err);
            resolve(results);
        });
    });
};
