const locationModel = require('../models/locationModel');
const tokenModel = require('../models/tokenModel');

exports.getStates = async (req, res) => {
    const authToken = req.header('Authorization')?.replace('Bearer ', '');

    const isValid = await tokenModel.validateToken(authToken);
    if (!isValid) {
        return res.status(401).json({ error: 'Invalid access token' });
    }

    const countryName = req.params.country_name || '';
    const states = await locationModel.getStates(countryName);

    if (states.length > 0) {
        return res.status(200).json(states);
    } else {
        return res.status(404).json({ error: 'No states found for the specified country' });
    }
};

exports.getCities = async (req, res) => {
    const authToken = req.header('Authorization')?.replace('Bearer ', '');

    const isValid = await tokenModel.validateToken(authToken);
    if (!isValid) {
        return res.status(401).json({ error: 'Invalid access token' });
    }

    const stateName = decodeURIComponent(req.params.state_name);
    const cities = await locationModel.getCitiesByState(stateName);

    if (cities.length > 0) {
        return res.status(200).json(cities);
    } else {
        return res.status(404).json({ error: 'No cities found for the specified state' });
    }
};
