<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Users_model extends CI_Model
{

    function __construct()
    {
        parent::__construct();
        $this->load->database();
    }


    public function getAllUsers()
    {

        // $query = $this->db->query('SELECT vc.id, hd.type, hd.head_title, vc.title, vc.description, vc.video_poster, vc.adult_logo, vc.video_name, vc.created_at FROM headers AS hd INNER JOIN video_contant AS vc ON hd.id = vc.hid');
        $query = $this->db->query('SELECT vc.id, hd.type, hd.head_title, vc.title, vc.description, vc.video_poster, vc.adult_logo, vc.video_name, vc.created_at
FROM headers AS hd
INNER JOIN video_contant AS vc ON hd.id = vc.hid
ORDER BY
    CASE
        WHEN vc.id = (SELECT MIN(id) FROM video_contant) THEN 0
        ELSE 1
    END,
    vc.created_at DESC;');
        $result = $query->result_array();
        // Initialize the output array
        $output = array();

        // Loop through the result and format the output
        foreach ($result as $row) {
            // Check if the head title already exists in the output array
            if (array_key_exists($row['head_title'], $output)) {
                // If it does, add the related data to the existing array
                $relatedData = array(
                    'id' => $row['id'],
                    'type' => $row['type'],
                    'title' => $row['title'],
                    'description' => $row['description'],
                    'video_poster' => $row['video_poster'],
                    'adult_logo' => $row['adult_logo'],
                    'video_name' => $row['video_name'],
                    'created_at' => $row['created_at']
                );
                array_push($output[$row['head_title']]['Related_Data'], $relatedData);
            } else {
                // If it doesn't, create a new array for the head title and add the related data
                $relatedData = array(
                    'id' => $row['id'],
                    'type' => $row['type'],
                    'title' => $row['title'],
                    'description' => $row['description'],
                    'video_poster' => $row['video_poster'],
                    'adult_logo' => $row['adult_logo'],
                    'video_name' => $row['video_name'],
                    'created_at' => $row['created_at']
                );
                $output[$row['head_title']] = array(
                    'Head_title' => $row['head_title'],
                    'type' => $row['type'],
                    'Related_Data' => array($relatedData)
                );
            }
        }

        $jsonOutput = json_encode(array_values($output));

        return $jsonOutput;
    }


    public function getuserbyid($id)
    {
        $query = $this->db->query('SELECT vc.id,vc.hid, hd.type, hd.head_title, vc.title, vc.description, vc.video_poster, vc.adult_logo, vc.video_name, vc.created_at FROM headers AS hd INNER JOIN video_contant AS vc ON hd.id = vc.hid WHERE vc.id = "' . $id . '"');
        $result = $query->result_array();
        $jsonOutput = json_encode(array_values($result));

        return $jsonOutput;
    }

    public function getUserListbyid($id)
    {
        $query = $this->db->query('SELECT vc.id,vc.hid, hd.type, hd.head_title, vc.title, vc.description, vc.video_poster, vc.adult_logo, vc.video_name, vc.created_at FROM headers AS hd INNER JOIN video_contant AS vc ON hd.id = vc.hid WHERE vc.hid = "' . $id . '"');
        $result = $query->result_array();
        $jsonOutput = json_encode(array_values($result));

        return $jsonOutput;
    }
}
