<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class LocationModel extends CI_Model {

    public function __construct() {
        parent::__construct();
    }

    // Get all states
    public function getStates($country_name) {
        $this->db->select('states.*'); 
        $this->db->from('states');
        $this->db->join('country', 'country.id = states.country_id'); 
        $this->db->where('country.country_name', $country_name);
        $query = $this->db->get();
        // Print the query for debugging
        // echo $this->db->last_query();
        return $query->result_array();
    }

    // Get cities by state id
    public function getCitiesByState($state_name) {
        // Fetch cities for a specific state
        $this->db->select('cities.*'); // Assuming you want all columns from the cities table
        $this->db->from('cities');
        $this->db->join('states', 'states.id = cities.state_id'); // Assuming a relation between states and cities
        $this->db->where('states.state_name', $state_name);
        $query = $this->db->get();
        // echo $this->db->last_query();
        return $query->result_array();
    }
}
