<?php
defined('BASEPATH') or exit('No direct script access allowed');

use chriskacerguis\RestServer\RestController;

require APPPATH . 'libraries/RestController.php';

class LocationController extends RestController
{
    private $valid_api_key = "j9EF8D8eDp_H5D40m01kiK9E7JnY7s8Yd8bkFkzIUs945wrtSCMTl94WJ7BW0Mbznh4";
    private $valid_user_email = "ingaleaarti956@gmail.com";

    public function __construct()
    {
        parent::__construct();
        $this->load->model('LocationModel');
        $this->load->database(); // Load the database
        $this->load->helper('string');
    }

    public function index()
    {
        echo 'working rest api';
    }

    /**
     * Generates an access token if the provided user email and API key are valid.
     *
     * @return void
     */
    public function getAccessToken_get()
    {
        $user_email = $this->input->get_request_header('user-email', TRUE);
        $api_key = $this->input->get_request_header('api-token', TRUE);

        if ($user_email === $this->valid_user_email && $api_key === $this->valid_api_key) {

            $access_token = random_string('alnum', 40);
            $this->db->insert('access_tokens', [
                'token' => $access_token,
                'created_at' => date('Y-m-d H:i:s')
            ]);

            // Return the token to the client
            $this->output->set_content_type('application/json')
                ->set_status_header(200)
                ->set_output(json_encode(['auth_token' => $access_token]));
        } else {
            // Invalid API key or user email
            log_message('error', 'Invalid API Key or User Email');
            $this->output->set_content_type('application/json')
                ->set_status_header(401)
                ->set_output(json_encode(['error' => 'Invalid API key or user email']));
        }
    }

    /**
     * Get all states based on the country name.
     *
     * @return void
     */
    public function getStates_get($country_name = '')
    {
        // Extract the Bearer token from the Authorization header
        $auth_token = $this->input->get_request_header('Authorization', TRUE);

        // Log the received token for debugging
        log_message('debug', 'Received Authorization Header: ' . $auth_token);

        // Validate the Bearer token
        if (!$this->validateToken($auth_token)) {
            log_message('error', 'Invalid Access Token');
            $this->output->set_content_type('application/json')
                ->set_status_header(401)
                ->set_output(json_encode(['error' => 'Invalid access token']));
            return;
        }

        // Fetch states using the country name
        $states = $this->LocationModel->getStates($country_name);

        if (!empty($states)) {
            // Return the states as a JSON response
            $this->output->set_content_type('application/json')
                ->set_status_header(200)
                ->set_output(json_encode($states));
        } else {
            // If no states found, return an error
            $this->output->set_content_type('application/json')
                ->set_status_header(404)
                ->set_output(json_encode(['error' => 'No states found for the specified country']));
        }
    }

    /**
     * Get cities based on the state name.
     *
     * @return void
     */
    public function getCities_get($state_name = '')
    {
        // Decode the state name to handle spaces
        $state_name = urldecode($state_name);

        // Extract the Bearer token from the Authorization header
        $auth_token = $this->input->get_request_header('Authorization', TRUE);

        // Validate the Bearer token
        if (!$this->validateToken($auth_token)) {
            log_message('error', 'Invalid Access Token');
            $this->output->set_content_type('application/json')
                ->set_status_header(401)
                ->set_output(json_encode(['error' => 'Invalid access token']));
            return;
        }

        // Fetch cities using the decoded state name
        $cities = $this->LocationModel->getCitiesByState($state_name);

        if (!empty($cities)) {
            // Return the cities as a JSON response
            $this->output->set_content_type('application/json')
                ->set_status_header(200)
                ->set_output(json_encode($cities));
        } else {
            // If no cities found, return an error
            $this->output->set_content_type('application/json')
                ->set_status_header(404)
                ->set_output(json_encode(['error' => 'No cities found for the specified state']));
        }
    }

    /**
     * Helper method to validate the Bearer token
     *
     * @param string $auth_token
     * @return bool
     */
    private function validateToken($auth_token)
    {
        // Remove 'Bearer ' prefix and check if the token exists in the database
        $auth_token = str_replace('Bearer ', '', $auth_token);

        // Log the token for debugging purposes
        log_message('debug', 'Validating Token: ' . $auth_token);

        // Query the database to check if the token exists
        $query = $this->db->get_where('access_tokens', ['token' => $auth_token]);

        return $query->num_rows() > 0;
    }
}
